/*********
  Kochkiste 5  (17.2.2021)
  Software für die Kochkiste
  Temperaturmessung mit dem ESP-01 und dem digitalem Sensor DS18B20.
  Ausgehend von dem Programm zur Temperaturmessung von Rui Santos ( https://RandomNerdTutorials.com ) 
  eine Temperaturmessung, eine Zeitmessung, Darstellung als Webseite
  Die HTML und CSS-Dateien liegen extra und werden über SPIFFS angesprochen
  außerdem existieren ein App-Icon und eine .csv Datei zum späteren Datenloggen
  
  getestet:
  - Temperaturmessung, Zeitmessung, Timer
  - mit SPIFFS ausgelagerter HTML und css Seite
  - AppIcon
  - löscht, legt neu an und schreibt csv Datei zum Datenloggen, abrufbar per Button
  - jede Minute kurzer Beep, wenn 75°C unterschritten wurden
  
*********/

// Import der nötigen libraries
#include <Arduino.h>
#include <ESP8266WiFi.h>
#include <Hash.h>
#include <ESPAsyncTCP.h>            // asyncroner Webserver
#include <ESPAsyncWebServer.h>      // asyncroner Webserver
#include <OneWire.h>                // oneWireBus für den Temperatursensor
#include <DallasTemperature.h>      // oneWireBus für den Temperatursensor
#include <FS.h>                     // SPIFFS
#include <Wire.h>

// Buseinstellungen für den Temperatursensor DS18B20                   
#define ONE_WIRE_BUS 2                      // GPIO2 --> ESP-01 pin5
OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);

// WLAN Einstellungen
const char* ssid = "username";      //  username und password austauschen
const char* password = "12345";

//  Globale Variablen
const byte beeperPin =  0;                  // Ausgang für Summer, GPIO0 --> ESP-01 pin3
int setTimer = 0;                           // Timerlaufzeit
int laufzeit;                               // aktuelle Zeit seit Start
int logger = 0;                             // für den Minutentackt des Datenloggers
int startzeit = millis();                   // Startzeit füer Timer und Garzeit
byte beeperTag =  0;                        // 1 = beeper Ein, 0 = Beeper Aus
int beeperTime = millis();                  // zum Überwachen des Beeperintervalls
const char* PARAM_INPUT = "timerChoice";    // Übergabeparameter für die Get-Prozedur des Timerwertes  
float tempC;                                // Temperaturwert in °C
File myfile;                                // Variable zum Anlegen und Schreiben der csv Datei

// AsyncWebServer object an Port 80
AsyncWebServer server(80);

//-------------------------------------------------------- SR ------------------------------------------------------------------
String readDSTemperatureC() {               // ruft die Temperaturdaten über den Bus ab
  sensors.requestTemperatures(); 
  tempC = sensors.getTempCByIndex(0);       // Temperatur in °C mit Nachkommastellen
  if(tempC == -127.00) {
    Serial.println("Failed to read from DS18B20 sensor");
    return "--";
  } else {
    Serial.print("Temperature Celsius: ");
    Serial.println(tempC); 
  }

  int temperatur = tempC;                   // zum Nachkommastellen streichen, in der WebApp werden nur ganze Grad angezeigt
  return String(temperatur);
}
//-------------------------------------------------------------------------------------------------------------
String readZeit() {                             // misst die Zeit 
  Serial.println("readZeit()");
//  int laufzeit = millis() - startzeit;               // seit Drücken des Startbuttons
  int laufzeit = millis() ;                            // seit dem Einschalten                 -- eine Zeile entfernen
   Serial.println(laufzeit);
  int stunde  = (laufzeit/3600000) % 24;               // teilt Stunden und Minuten
  int minuten = (laufzeit/60000) % 60;
  String laufzeitString = "";

if(minuten < 10) {
  laufzeitString = String(stunde) + ":0" + String(minuten);     // erzeugt String zum Schicken an die Webseite
  } else {
  laufzeitString = String(stunde) + ":" + String(minuten);
  }
    
  return String(laufzeitString);
}
//--------------------------------------------------------------------------- 
String readTimer() {                                  //  Übergibt die Timerzeit und setzt den Tag für den Beeper
    Serial.println("readTimer()");
int setTimerMill = (setTimer * 60000)+60000;  
String timer = "";
int timerStunden = (((setTimerMill - millis() + startzeit)/3600000) % 24);    //volle Sunden der Restlaufzeit
int timerMinuten = (((setTimerMill - millis() + startzeit)/60000) % 60);      // Minuten der Restlaufzeit
if(setTimerMill > millis() - startzeit +60000) {
  if(timerMinuten > 9 ) {
    timer = String(timerStunden) + ":" + String(timerMinuten);  // erzeugt String zum Schicken an die Webseite
    } else {
    timer = String(timerStunden) + ":0" + String(timerMinuten);
    } 
  } else {
  timer = "0:00";                     // dh. Zeit ist abgelaufen UND
  if(setTimer > 0 ) {                 // eine Zeit war vorgewählt
    beeperTag = 1;                    // --> bbeperTag wird gesetzt
   // Serial.println("Summer an ");
      }
  }
  return String(timer);
}
//--------------------------------------------------------------------------- 
void toggleBeeper() {                             //  beepen ohne delay, für den Buzzer
      Serial.println("toggleBeeper()");
    if (beeperTime + 1000 > millis()) {
      digitalWrite(beeperPin, LOW);
      Serial.println(millis() - beeperTime);
      Serial.println("Summer ein ");
      }
    else if(beeperTime + 2000 > millis()) {
      digitalWrite(beeperPin, HIGH);
      Serial.println(millis() - beeperTime);
      Serial.println("Summer aus ");
      }
    else {
      digitalWrite(beeperPin, HIGH);
      beeperTime = millis();
      }
}

// ------------------------------------------------------------------------
void messDatenSchreib() {                     // schreibt Daten in die csv Datei, wird einmal pro Minute aufgerufen
        Serial.println("messDatenSchreib()");
  myfile = SPIFFS.open("/messdaten.csv", "a");  // Öffne Datei um Daten anzuhängen ! (a - append)
  myfile.print(readZeit());                     // aktuelle Lauf-(Gar-)zeit
  myfile.print(";");                            // trennen durch Semicolon, braucht Excel zum Anlegen von Spalten
  myfile.println(tempC);                        // Temperatur mit 2 Nachkommastellen
  myfile.close();                               // Schließen der Datei
  if(tempC < 75.00) {                           // Dreifachbeep wenn Temperatur unter 75°C fällt
    for (int i = 0; i < 3; i++) {
    digitalWrite(beeperPin, LOW);
    Serial.println("piiiiip");
    delay (500);
    digitalWrite(beeperPin, HIGH);
    delay (250);
    }
  }
}
// ---------------------------------------------------- processor -----------------------------------------------------------------------
                                                                  // Tauscht die Platzhalter im HTML scriptmit den aktuellen Werten aus (zB %TC%)
String processor(const String& var){
     Serial.println("processor()");
  if(var == "TC"){
    return readDSTemperatureC();    
  }
  else if(var == "ZT"){
    return readZeit();             
  }
    else if(var == "TM"){
    return readTimer();            
  }
  return String();
}
// ---------------------------------------------------- setup -----------------------------------------------------------------
void setup(){
  pinMode(beeperPin, OUTPUT);
  digitalWrite(beeperPin, HIGH);

  Serial.begin(115200);                               // Serial port zum Auslesen IP-Adresse
  Serial.print("Los ");      
  Serial.println();
  
//  sensors.begin();                                                // Start der DS18B20 library - nicht nötig?

                                // -------------------- Initialize SPIFFS
  if(!SPIFFS.begin()){
    Serial.println("An Error has occurred while mounting SPIFFS");
    return;
  }
                                // ------------------- Anlege csv Datei
     SPIFFS.remove("/messdaten.csv");                               // alte Datei wird gelöscht
     myfile = SPIFFS.open("/messdaten.csv", "w");                   // neue, leere Datei angelegt
     myfile.close();
                                // ------------------- WLAN Verbindung
  WiFi.begin(ssid, password);                                       
  Serial.println("Connecting to WiFi");                             // mit WLAN verbinden
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println();
  Serial.println(WiFi.localIP());                                   // Ausgabe der IP Address
  
// ----------------------------------------- HTTP methods ----------------------------------------------------------
                                                                    // Route for root / web page
                                                                                // jede einzelne Datei, die Genutzt werden soll muss angemeldet werden
                                                                                // . html. css, csv, png ....
   server.on("/", HTTP_GET, [](AsyncWebServerRequest *request){                 
    request->send(SPIFFS, "/index.html", String(), false, processor);           
  });
  
  // Route to load style.css file
  server.on("/style.css", HTTP_GET, [](AsyncWebServerRequest *request){
    request->send(SPIFFS, "/style.css", "text/css");
  });

  // Route to load icon120.png file
  server.on("/icon120.png", HTTP_GET, [](AsyncWebServerRequest *request){
    request->send(SPIFFS, "/icon120.png", "image/png");
  });

    // Route to load messdaten.csv file
  server.on("/messdaten.csv", HTTP_GET, [](AsyncWebServerRequest *request){
    request->send(SPIFFS, "/messdaten.csv", "text/csv");
  });

                                                                            // für die Anfragen aus Javasript
  server.on("/temperaturec", HTTP_GET, [](AsyncWebServerRequest *request){
    request->send_P(200, "text/plain", readDSTemperatureC().c_str());
  });
  server.on("/zeit", HTTP_GET, [](AsyncWebServerRequest *request){
    request->send_P(200, "text/plain", readZeit().c_str());
  });
    server.on("/timer", HTTP_GET, [](AsyncWebServerRequest *request){
    request->send_P(200, "text/plain", readTimer().c_str());
  });

  // Send a GET request to <ESP_IP>/get?input1=<inputMessage>            ----------- hängt den timerwert an die IP-Adresse -------------
  server.on("/get", HTTP_GET, [] (AsyncWebServerRequest *request) {
    String inputMessage;
    inputMessage = request->getParam(PARAM_INPUT)->value();


if (inputMessage == "3") {setTimer = 3;}                                // Übergabe des Timerwertes
  else if(inputMessage == "15") {setTimer = 15;}
  else if(inputMessage == "20") {setTimer = 20;}
  else if(inputMessage == "25") {setTimer = 25;}
  else if(inputMessage == "30") {setTimer = 30;}
  else if(inputMessage == "35") {setTimer = 35;}
  else if(inputMessage == "40") {setTimer = 40;}
  else if(inputMessage == "45") {setTimer = 45;}
  else if(inputMessage == "50") {setTimer = 50;}
  else if(inputMessage == "55") {setTimer = 55;}
  else if(inputMessage == "60") {setTimer = 60;}
  else if(inputMessage == "70") {setTimer = 70;}
  else if(inputMessage == "80") {setTimer = 80;}
  else if(inputMessage == "90") {setTimer = 90;}
  else if(inputMessage == "100") {setTimer = 100;}
  else if(inputMessage == "110") {setTimer = 110;}
  else if(inputMessage == "120") {setTimer = 120;}
  else if(inputMessage == "135") {setTimer = 135;}
  else if(inputMessage == "150") {setTimer = 150;}
  else if(inputMessage == "165") {setTimer = 165;}
  else if(inputMessage == "180") {setTimer = 180;}
  else {setTimer = 0;}
  startzeit = millis();
  beeperTag = 0;
  Serial.println("Summer aus ");
    request->send(SPIFFS, "/index.html", String(), false, processor);              // frischt die Seite auf, da sonst der Server unter den wiederkehrenden requests zusammenbricht
    });

  server.begin();                                               // Start server
}
// ------------------------------------------------------------------------------------------------------------- 
void loop(){                                            // im loop werden nur die Zeiten für den Beeper und den Datenlogger überwacht
if(beeperTag != 0){                                     // Wenn beeperTag gesetzt (dh. die vorgewählte zeit abgelaufen ist):
     toggleBeeper();                                    // beepen ohne delay
   } else {
     digitalWrite(beeperPin, HIGH);  
     beeperTime = millis();  
   }
   if(logger < millis()/60000){                          // nach jeder Minute zum Unterprogramm csv Schreiben
   logger++; 
     Serial.println("--------1");
   messDatenSchreib();
     Serial.println("--------3");

//    digitalWrite(beeperPin, LOW);                       //test piep
//    Serial.println("pipp");
//    delay (100);
//    digitalWrite(beeperPin, HIGH);
//    delay (100);
     readTimer();
   }
}
